<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItem {
	private static array $schema = ['type' => 'object', 'required' => ['id', 'status', 'changes', 'creationTime', 'finishTime'], 'properties' => ['id' => ['type' => 'integer'], 'status' => ['type' => 'string', 'enum' => ['pending', 'success', 'error']], 'creationTime' => ['type' => 'string', 'format' => 'date-time'], 'finishTime' => ['type' => ['string', 'null'], 'format' => 'date-time'], 'changes' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['acf' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]], 'new' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]]], 'required' => ['old', 'new']], 'basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'parentId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'name' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionLong' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionShort' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'imageId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'galleryImageIds' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'array', 'items' => ['type' => 'integer']], 'new' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'postStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'new' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']]]], 'sku' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'regularPrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'salePrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'stock' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'stockStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]]]], 'taxClass' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]]]], 'taxStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]]]], 'totalSales' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]]]], 'customMeta' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]]], 'required' => ['old', 'new']], 'defaultTaxonomy' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']], 'productAttribute' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']]]], 'error' => ['anyOf' => [['type' => ['object'], 'required' => ['field', 'expected', 'actual'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['value_mismatch'], 'default' => 'value_mismatch'], 'field' => ['type' => 'string'], 'expected' => ['type' => ['string', 'number', 'array', 'null']], 'actual' => ['type' => ['string', 'number', 'array', 'null']]]], ['type' => ['object'], 'required' => ['message'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['unknown_error'], 'default' => 'unknown_error'], 'message' => ['type' => 'string']]]]]]];
	private int $id;
	private JobProductsItemStatus $status;
	private \DateTime $creationTime;
	private $finishTime;
	private JobProductsItemChanges $changes;
	private JobProductsItemErrorAlternative1|JobProductsItemErrorAlternative2|null $error = null;

	public function __construct(int $id, JobProductsItemStatus $status, \DateTime $creationTime, $finishTime, JobProductsItemChanges $changes) {
		$this->id = $id;
		$this->status = $status;
		$this->creationTime = $creationTime;
		$this->finishTime = $finishTime;
		$this->changes = $changes;
	}

	public function getId(): int {
		return $this->id;
	}

	public function getStatus(): JobProductsItemStatus {
		return $this->status;
	}

	public function getCreationTime(): \DateTime {
		return $this->creationTime;
	}

	public function getFinishTime() {
		return $this->finishTime;
	}

	public function getChanges(): JobProductsItemChanges {
		return $this->changes;
	}

	public function getError(): JobProductsItemErrorAlternative1|JobProductsItemErrorAlternative2|null {
		return $this->error;
	}

	public function withId(int $id): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($id, self::$schema['properties']['id']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->id = $id;

		return $clone;
	}

	public function withStatus(JobProductsItemStatus $status): self {
		$clone = clone $this;
		$clone->status = $status;

		return $clone;
	}

	public function withCreationTime(\DateTime $creationTime): self {
		$clone = clone $this;
		$clone->creationTime = $creationTime;

		return $clone;
	}

	public function withFinishTime($finishTime): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($finishTime, self::$schema['properties']['finishTime']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->finishTime = $finishTime;

		return $clone;
	}

	public function withChanges(JobProductsItemChanges $changes): self {
		$clone = clone $this;
		$clone->changes = $changes;

		return $clone;
	}

	public function withError(JobProductsItemErrorAlternative1|JobProductsItemErrorAlternative2 $error): self {
		$clone = clone $this;
		$clone->error = $error;

		return $clone;
	}

	public function withoutError(): self {
		$clone = clone $this;
		unset($clone->error);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItem {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $id = (int) $input->{'id'};
		$status = JobProductsItemStatus::from($input->{'status'});
		$creationTime = new \DateTime($input->{'creationTime'});
		$finishTime = $input->{'finishTime'};
		$changes = JobProductsItemChanges::buildFromInput($input->{'changes'}, validate: $validate);
		$error = null;
		if (isset($input->{'error'})) {
			$error = match (true) {
				JobProductsItemErrorAlternative1::validateInput($input->{'error'}, true) => JobProductsItemErrorAlternative1::buildFromInput($input->{'error'}, validate: $validate), JobProductsItemErrorAlternative2::validateInput($input->{'error'}, true) => JobProductsItemErrorAlternative2::buildFromInput($input->{'error'}, validate: $validate), default => throw new \InvalidArgumentException("could not build property 'error' from JSON"),
			};
		} $obj = new self($id, $status, $creationTime, $finishTime, $changes);
		$obj->error = $error;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['id'] = $this->id;
		$output['status'] = $this->status->value;
		$output['creationTime'] = $this->creationTime->format(\DateTime::ATOM);
		$output['finishTime'] = $this->finishTime;
		$output['changes'] = $this->changes->toJson();
		if (isset($this->error)) {
			$output['error'] = match (true) {
				$this->error instanceof JobProductsItemErrorAlternative1, $this->error instanceof JobProductsItemErrorAlternative2 => $this->error->toJson(),
			};
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->creationTime = clone $this->creationTime;
		$this->changes = clone $this->changes;
		if (isset($this->error)) {
			$this->error = match (true) {
				$this->error instanceof JobProductsItemErrorAlternative1, $this->error instanceof JobProductsItemErrorAlternative2 => clone $this->error,
			};
		}
	}
}
