<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChanges {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'properties' => ['acf' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]], 'new' => ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]]], 'required' => ['old', 'new']], 'basic' => ['type' => 'object', 'properties' => ['id' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'parentId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'name' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionLong' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionShort' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'imageId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'galleryImageIds' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'array', 'items' => ['type' => 'integer']], 'new' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'postStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'new' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']]]], 'sku' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'regularPrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'salePrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'stock' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'stockStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]]]], 'taxClass' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]]]], 'taxStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]]]], 'totalSales' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]]]], 'customMeta' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]]], 'required' => ['old', 'new']], 'defaultTaxonomy' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']], 'productAttribute' => ['type' => 'object', 'additionalProperties' => false, 'properties' => ['old' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]], 'new' => ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'required' => ['old', 'new']]]];
	private ?JobProductsItemChangesAcf $acf = null;
	private ?JobProductsItemChangesBasic $basic = null;
	private ?JobProductsItemChangesCustomMeta $customMeta = null;
	private ?JobProductsItemChangesDefaultTaxonomy $defaultTaxonomy = null;
	private ?JobProductsItemChangesProductAttribute $productAttribute = null;

	public function __construct() {
	}

	public function getAcf(): ?JobProductsItemChangesAcf {
		return $this->acf ?? null;
	}

	public function getBasic(): ?JobProductsItemChangesBasic {
		return $this->basic ?? null;
	}

	public function getCustomMeta(): ?JobProductsItemChangesCustomMeta {
		return $this->customMeta ?? null;
	}

	public function getDefaultTaxonomy(): ?JobProductsItemChangesDefaultTaxonomy {
		return $this->defaultTaxonomy ?? null;
	}

	public function getProductAttribute(): ?JobProductsItemChangesProductAttribute {
		return $this->productAttribute ?? null;
	}

	public function withAcf(JobProductsItemChangesAcf $acf): self {
		$clone = clone $this;
		$clone->acf = $acf;

		return $clone;
	}

	public function withoutAcf(): self {
		$clone = clone $this;
		unset($clone->acf);

		return $clone;
	}

	public function withBasic(JobProductsItemChangesBasic $basic): self {
		$clone = clone $this;
		$clone->basic = $basic;

		return $clone;
	}

	public function withoutBasic(): self {
		$clone = clone $this;
		unset($clone->basic);

		return $clone;
	}

	public function withCustomMeta(JobProductsItemChangesCustomMeta $customMeta): self {
		$clone = clone $this;
		$clone->customMeta = $customMeta;

		return $clone;
	}

	public function withoutCustomMeta(): self {
		$clone = clone $this;
		unset($clone->customMeta);

		return $clone;
	}

	public function withDefaultTaxonomy(JobProductsItemChangesDefaultTaxonomy $defaultTaxonomy): self {
		$clone = clone $this;
		$clone->defaultTaxonomy = $defaultTaxonomy;

		return $clone;
	}

	public function withoutDefaultTaxonomy(): self {
		$clone = clone $this;
		unset($clone->defaultTaxonomy);

		return $clone;
	}

	public function withProductAttribute(JobProductsItemChangesProductAttribute $productAttribute): self {
		$clone = clone $this;
		$clone->productAttribute = $productAttribute;

		return $clone;
	}

	public function withoutProductAttribute(): self {
		$clone = clone $this;
		unset($clone->productAttribute);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChanges {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $acf = null;
		if (isset($input->{'acf'})) {
			$acf = JobProductsItemChangesAcf::buildFromInput($input->{'acf'}, validate: $validate);
		} $basic = null;
		if (isset($input->{'basic'})) {
			$basic = JobProductsItemChangesBasic::buildFromInput($input->{'basic'}, validate: $validate);
		} $customMeta = null;
		if (isset($input->{'customMeta'})) {
			$customMeta = JobProductsItemChangesCustomMeta::buildFromInput($input->{'customMeta'}, validate: $validate);
		} $defaultTaxonomy = null;
		if (isset($input->{'defaultTaxonomy'})) {
			$defaultTaxonomy = JobProductsItemChangesDefaultTaxonomy::buildFromInput($input->{'defaultTaxonomy'}, validate: $validate);
		} $productAttribute = null;
		if (isset($input->{'productAttribute'})) {
			$productAttribute = JobProductsItemChangesProductAttribute::buildFromInput($input->{'productAttribute'}, validate: $validate);
		} $obj = new self();
		$obj->acf = $acf;
		$obj->basic = $basic;
		$obj->customMeta = $customMeta;
		$obj->defaultTaxonomy = $defaultTaxonomy;
		$obj->productAttribute = $productAttribute;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->acf)) {
			$output['acf'] = $this->acf->toJson();
		} if (isset($this->basic)) {
			$output['basic'] = $this->basic->toJson();
		} if (isset($this->customMeta)) {
			$output['customMeta'] = $this->customMeta->toJson();
		} if (isset($this->defaultTaxonomy)) {
			$output['defaultTaxonomy'] = $this->defaultTaxonomy->toJson();
		} if (isset($this->productAttribute)) {
			$output['productAttribute'] = $this->productAttribute->toJson();
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->acf)) {
			$this->acf = clone $this->acf;
		} if (isset($this->basic)) {
			$this->basic = clone $this->basic;
		} if (isset($this->customMeta)) {
			$this->customMeta = clone $this->customMeta;
		} if (isset($this->defaultTaxonomy)) {
			$this->defaultTaxonomy = clone $this->defaultTaxonomy;
		} if (isset($this->productAttribute)) {
			$this->productAttribute = clone $this->productAttribute;
		}
	}
}
