<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesBasic {
	private static array $schema = ['type' => 'object', 'properties' => ['id' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'parentId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]], 'name' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionLong' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'descriptionShort' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'imageId' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'galleryImageIds' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'array', 'items' => ['type' => 'integer']], 'new' => ['type' => 'array', 'items' => ['type' => 'integer']]]], 'postStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']], 'new' => ['type' => 'string', 'enum' => ['draft', 'pending', 'private', 'publish', 'trash']]]], 'sku' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'string'], 'new' => ['type' => 'string']]], 'regularPrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'salePrice' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'number'], ['type' => 'null']]]]], 'stock' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'integer'], ['type' => 'null']]]]], 'stockStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['instock', 'onbackorder', 'outofstock']], ['type' => 'null']]]]], 'taxClass' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string'], ['type' => 'null']]]]], 'taxStatus' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]]]], 'totalSales' => ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['type' => 'integer'], 'new' => ['type' => 'integer']]]]];
	private ?JobProductsItemChangesBasicId $id = null;
	private ?JobProductsItemChangesBasicParentId $parentId = null;
	private ?JobProductsItemChangesBasicName $name = null;
	private ?JobProductsItemChangesBasicDescriptionLong $descriptionLong = null;
	private ?JobProductsItemChangesBasicDescriptionShort $descriptionShort = null;
	private ?JobProductsItemChangesBasicImageId $imageId = null;
	private ?JobProductsItemChangesBasicGalleryImageIds $galleryImageIds = null;
	private ?JobProductsItemChangesBasicPostStatus $postStatus = null;
	private ?JobProductsItemChangesBasicSku $sku = null;
	private ?JobProductsItemChangesBasicRegularPrice $regularPrice = null;
	private ?JobProductsItemChangesBasicSalePrice $salePrice = null;
	private ?JobProductsItemChangesBasicStock $stock = null;
	private ?JobProductsItemChangesBasicStockStatus $stockStatus = null;
	private ?JobProductsItemChangesBasicTaxClass $taxClass = null;
	private ?JobProductsItemChangesBasicTaxStatus $taxStatus = null;
	private ?JobProductsItemChangesBasicTotalSales $totalSales = null;

	public function __construct() {
	}

	public function getId(): ?JobProductsItemChangesBasicId {
		return $this->id ?? null;
	}

	public function getParentId(): ?JobProductsItemChangesBasicParentId {
		return $this->parentId ?? null;
	}

	public function getName(): ?JobProductsItemChangesBasicName {
		return $this->name ?? null;
	}

	public function getDescriptionLong(): ?JobProductsItemChangesBasicDescriptionLong {
		return $this->descriptionLong ?? null;
	}

	public function getDescriptionShort(): ?JobProductsItemChangesBasicDescriptionShort {
		return $this->descriptionShort ?? null;
	}

	public function getImageId(): ?JobProductsItemChangesBasicImageId {
		return $this->imageId ?? null;
	}

	public function getGalleryImageIds(): ?JobProductsItemChangesBasicGalleryImageIds {
		return $this->galleryImageIds ?? null;
	}

	public function getPostStatus(): ?JobProductsItemChangesBasicPostStatus {
		return $this->postStatus ?? null;
	}

	public function getSku(): ?JobProductsItemChangesBasicSku {
		return $this->sku ?? null;
	}

	public function getRegularPrice(): ?JobProductsItemChangesBasicRegularPrice {
		return $this->regularPrice ?? null;
	}

	public function getSalePrice(): ?JobProductsItemChangesBasicSalePrice {
		return $this->salePrice ?? null;
	}

	public function getStock(): ?JobProductsItemChangesBasicStock {
		return $this->stock ?? null;
	}

	public function getStockStatus(): ?JobProductsItemChangesBasicStockStatus {
		return $this->stockStatus ?? null;
	}

	public function getTaxClass(): ?JobProductsItemChangesBasicTaxClass {
		return $this->taxClass ?? null;
	}

	public function getTaxStatus(): ?JobProductsItemChangesBasicTaxStatus {
		return $this->taxStatus ?? null;
	}

	public function getTotalSales(): ?JobProductsItemChangesBasicTotalSales {
		return $this->totalSales ?? null;
	}

	public function withId(JobProductsItemChangesBasicId $id): self {
		$clone = clone $this;
		$clone->id = $id;

		return $clone;
	}

	public function withoutId(): self {
		$clone = clone $this;
		unset($clone->id);

		return $clone;
	}

	public function withParentId(JobProductsItemChangesBasicParentId $parentId): self {
		$clone = clone $this;
		$clone->parentId = $parentId;

		return $clone;
	}

	public function withoutParentId(): self {
		$clone = clone $this;
		unset($clone->parentId);

		return $clone;
	}

	public function withName(JobProductsItemChangesBasicName $name): self {
		$clone = clone $this;
		$clone->name = $name;

		return $clone;
	}

	public function withoutName(): self {
		$clone = clone $this;
		unset($clone->name);

		return $clone;
	}

	public function withDescriptionLong(JobProductsItemChangesBasicDescriptionLong $descriptionLong): self {
		$clone = clone $this;
		$clone->descriptionLong = $descriptionLong;

		return $clone;
	}

	public function withoutDescriptionLong(): self {
		$clone = clone $this;
		unset($clone->descriptionLong);

		return $clone;
	}

	public function withDescriptionShort(JobProductsItemChangesBasicDescriptionShort $descriptionShort): self {
		$clone = clone $this;
		$clone->descriptionShort = $descriptionShort;

		return $clone;
	}

	public function withoutDescriptionShort(): self {
		$clone = clone $this;
		unset($clone->descriptionShort);

		return $clone;
	}

	public function withImageId(JobProductsItemChangesBasicImageId $imageId): self {
		$clone = clone $this;
		$clone->imageId = $imageId;

		return $clone;
	}

	public function withoutImageId(): self {
		$clone = clone $this;
		unset($clone->imageId);

		return $clone;
	}

	public function withGalleryImageIds(JobProductsItemChangesBasicGalleryImageIds $galleryImageIds): self {
		$clone = clone $this;
		$clone->galleryImageIds = $galleryImageIds;

		return $clone;
	}

	public function withoutGalleryImageIds(): self {
		$clone = clone $this;
		unset($clone->galleryImageIds);

		return $clone;
	}

	public function withPostStatus(JobProductsItemChangesBasicPostStatus $postStatus): self {
		$clone = clone $this;
		$clone->postStatus = $postStatus;

		return $clone;
	}

	public function withoutPostStatus(): self {
		$clone = clone $this;
		unset($clone->postStatus);

		return $clone;
	}

	public function withSku(JobProductsItemChangesBasicSku $sku): self {
		$clone = clone $this;
		$clone->sku = $sku;

		return $clone;
	}

	public function withoutSku(): self {
		$clone = clone $this;
		unset($clone->sku);

		return $clone;
	}

	public function withRegularPrice(JobProductsItemChangesBasicRegularPrice $regularPrice): self {
		$clone = clone $this;
		$clone->regularPrice = $regularPrice;

		return $clone;
	}

	public function withoutRegularPrice(): self {
		$clone = clone $this;
		unset($clone->regularPrice);

		return $clone;
	}

	public function withSalePrice(JobProductsItemChangesBasicSalePrice $salePrice): self {
		$clone = clone $this;
		$clone->salePrice = $salePrice;

		return $clone;
	}

	public function withoutSalePrice(): self {
		$clone = clone $this;
		unset($clone->salePrice);

		return $clone;
	}

	public function withStock(JobProductsItemChangesBasicStock $stock): self {
		$clone = clone $this;
		$clone->stock = $stock;

		return $clone;
	}

	public function withoutStock(): self {
		$clone = clone $this;
		unset($clone->stock);

		return $clone;
	}

	public function withStockStatus(JobProductsItemChangesBasicStockStatus $stockStatus): self {
		$clone = clone $this;
		$clone->stockStatus = $stockStatus;

		return $clone;
	}

	public function withoutStockStatus(): self {
		$clone = clone $this;
		unset($clone->stockStatus);

		return $clone;
	}

	public function withTaxClass(JobProductsItemChangesBasicTaxClass $taxClass): self {
		$clone = clone $this;
		$clone->taxClass = $taxClass;

		return $clone;
	}

	public function withoutTaxClass(): self {
		$clone = clone $this;
		unset($clone->taxClass);

		return $clone;
	}

	public function withTaxStatus(JobProductsItemChangesBasicTaxStatus $taxStatus): self {
		$clone = clone $this;
		$clone->taxStatus = $taxStatus;

		return $clone;
	}

	public function withoutTaxStatus(): self {
		$clone = clone $this;
		unset($clone->taxStatus);

		return $clone;
	}

	public function withTotalSales(JobProductsItemChangesBasicTotalSales $totalSales): self {
		$clone = clone $this;
		$clone->totalSales = $totalSales;

		return $clone;
	}

	public function withoutTotalSales(): self {
		$clone = clone $this;
		unset($clone->totalSales);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesBasic {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $id = null;
		if (isset($input->{'id'})) {
			$id = JobProductsItemChangesBasicId::buildFromInput($input->{'id'}, validate: $validate);
		} $parentId = null;
		if (isset($input->{'parentId'})) {
			$parentId = JobProductsItemChangesBasicParentId::buildFromInput($input->{'parentId'}, validate: $validate);
		} $name = null;
		if (isset($input->{'name'})) {
			$name = JobProductsItemChangesBasicName::buildFromInput($input->{'name'}, validate: $validate);
		} $descriptionLong = null;
		if (isset($input->{'descriptionLong'})) {
			$descriptionLong = JobProductsItemChangesBasicDescriptionLong::buildFromInput($input->{'descriptionLong'}, validate: $validate);
		} $descriptionShort = null;
		if (isset($input->{'descriptionShort'})) {
			$descriptionShort = JobProductsItemChangesBasicDescriptionShort::buildFromInput($input->{'descriptionShort'}, validate: $validate);
		} $imageId = null;
		if (isset($input->{'imageId'})) {
			$imageId = JobProductsItemChangesBasicImageId::buildFromInput($input->{'imageId'}, validate: $validate);
		} $galleryImageIds = null;
		if (isset($input->{'galleryImageIds'})) {
			$galleryImageIds = JobProductsItemChangesBasicGalleryImageIds::buildFromInput($input->{'galleryImageIds'}, validate: $validate);
		} $postStatus = null;
		if (isset($input->{'postStatus'})) {
			$postStatus = JobProductsItemChangesBasicPostStatus::buildFromInput($input->{'postStatus'}, validate: $validate);
		} $sku = null;
		if (isset($input->{'sku'})) {
			$sku = JobProductsItemChangesBasicSku::buildFromInput($input->{'sku'}, validate: $validate);
		} $regularPrice = null;
		if (isset($input->{'regularPrice'})) {
			$regularPrice = JobProductsItemChangesBasicRegularPrice::buildFromInput($input->{'regularPrice'}, validate: $validate);
		} $salePrice = null;
		if (isset($input->{'salePrice'})) {
			$salePrice = JobProductsItemChangesBasicSalePrice::buildFromInput($input->{'salePrice'}, validate: $validate);
		} $stock = null;
		if (isset($input->{'stock'})) {
			$stock = JobProductsItemChangesBasicStock::buildFromInput($input->{'stock'}, validate: $validate);
		} $stockStatus = null;
		if (isset($input->{'stockStatus'})) {
			$stockStatus = JobProductsItemChangesBasicStockStatus::buildFromInput($input->{'stockStatus'}, validate: $validate);
		} $taxClass = null;
		if (isset($input->{'taxClass'})) {
			$taxClass = JobProductsItemChangesBasicTaxClass::buildFromInput($input->{'taxClass'}, validate: $validate);
		} $taxStatus = null;
		if (isset($input->{'taxStatus'})) {
			$taxStatus = JobProductsItemChangesBasicTaxStatus::buildFromInput($input->{'taxStatus'}, validate: $validate);
		} $totalSales = null;
		if (isset($input->{'totalSales'})) {
			$totalSales = JobProductsItemChangesBasicTotalSales::buildFromInput($input->{'totalSales'}, validate: $validate);
		} $obj = new self();
		$obj->id = $id;
		$obj->parentId = $parentId;
		$obj->name = $name;
		$obj->descriptionLong = $descriptionLong;
		$obj->descriptionShort = $descriptionShort;
		$obj->imageId = $imageId;
		$obj->galleryImageIds = $galleryImageIds;
		$obj->postStatus = $postStatus;
		$obj->sku = $sku;
		$obj->regularPrice = $regularPrice;
		$obj->salePrice = $salePrice;
		$obj->stock = $stock;
		$obj->stockStatus = $stockStatus;
		$obj->taxClass = $taxClass;
		$obj->taxStatus = $taxStatus;
		$obj->totalSales = $totalSales;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->id)) {
			$output['id'] = $this->id->toJson();
		} if (isset($this->parentId)) {
			$output['parentId'] = $this->parentId->toJson();
		} if (isset($this->name)) {
			$output['name'] = $this->name->toJson();
		} if (isset($this->descriptionLong)) {
			$output['descriptionLong'] = $this->descriptionLong->toJson();
		} if (isset($this->descriptionShort)) {
			$output['descriptionShort'] = $this->descriptionShort->toJson();
		} if (isset($this->imageId)) {
			$output['imageId'] = $this->imageId->toJson();
		} if (isset($this->galleryImageIds)) {
			$output['galleryImageIds'] = $this->galleryImageIds->toJson();
		} if (isset($this->postStatus)) {
			$output['postStatus'] = $this->postStatus->toJson();
		} if (isset($this->sku)) {
			$output['sku'] = $this->sku->toJson();
		} if (isset($this->regularPrice)) {
			$output['regularPrice'] = $this->regularPrice->toJson();
		} if (isset($this->salePrice)) {
			$output['salePrice'] = $this->salePrice->toJson();
		} if (isset($this->stock)) {
			$output['stock'] = $this->stock->toJson();
		} if (isset($this->stockStatus)) {
			$output['stockStatus'] = $this->stockStatus->toJson();
		} if (isset($this->taxClass)) {
			$output['taxClass'] = $this->taxClass->toJson();
		} if (isset($this->taxStatus)) {
			$output['taxStatus'] = $this->taxStatus->toJson();
		} if (isset($this->totalSales)) {
			$output['totalSales'] = $this->totalSales->toJson();
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->id)) {
			$this->id = clone $this->id;
		} if (isset($this->parentId)) {
			$this->parentId = clone $this->parentId;
		} if (isset($this->name)) {
			$this->name = clone $this->name;
		} if (isset($this->descriptionLong)) {
			$this->descriptionLong = clone $this->descriptionLong;
		} if (isset($this->descriptionShort)) {
			$this->descriptionShort = clone $this->descriptionShort;
		} if (isset($this->imageId)) {
			$this->imageId = clone $this->imageId;
		} if (isset($this->galleryImageIds)) {
			$this->galleryImageIds = clone $this->galleryImageIds;
		} if (isset($this->postStatus)) {
			$this->postStatus = clone $this->postStatus;
		} if (isset($this->sku)) {
			$this->sku = clone $this->sku;
		} if (isset($this->regularPrice)) {
			$this->regularPrice = clone $this->regularPrice;
		} if (isset($this->salePrice)) {
			$this->salePrice = clone $this->salePrice;
		} if (isset($this->stock)) {
			$this->stock = clone $this->stock;
		} if (isset($this->stockStatus)) {
			$this->stockStatus = clone $this->stockStatus;
		} if (isset($this->taxClass)) {
			$this->taxClass = clone $this->taxClass;
		} if (isset($this->taxStatus)) {
			$this->taxStatus = clone $this->taxStatus;
		} if (isset($this->totalSales)) {
			$this->totalSales = clone $this->totalSales;
		}
	}
}
