<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemChangesBasicTaxStatus {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'required' => ['old', 'new'], 'properties' => ['old' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]], 'new' => ['oneOf' => [['type' => 'string', 'enum' => ['none', 'shipping', 'taxable']], ['type' => 'null']]]]];
	private $old;
	private $new;

	public function __construct($old, $new) {
		$this->old = $old;
		$this->new = $new;
	}

	public function getOld() {
		return $this->old;
	}

	public function getNew() {
		return $this->new;
	}

	public function withOld($old): self {
		$clone = clone $this;
		$clone->old = $old;

		return $clone;
	}

	public function withNew($new): self {
		$clone = clone $this;
		$clone->new = $new;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemChangesBasicTaxStatus {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $old = match (true) {
			JobProductsItemChangesBasicTaxStatusOldAlternative1::tryFrom($input->{'old'}) !== null => JobProductsItemChangesBasicTaxStatusOldAlternative1::from($input->{'old'}), true => $input->{'old'}, default => throw new \InvalidArgumentException("could not build property 'old' from JSON"),
		};
		$new = match (true) {
			JobProductsItemChangesBasicTaxStatusNewAlternative1::tryFrom($input->{'new'}) !== null => JobProductsItemChangesBasicTaxStatusNewAlternative1::from($input->{'new'}), true => $input->{'new'}, default => throw new \InvalidArgumentException("could not build property 'new' from JSON"),
		};
		$obj = new self($old, $new);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['old'] = match (true) {
			$this->old instanceof JobProductsItemChangesBasicTaxStatusOldAlternative1 => $this->old->value, true => $this->old,
		};
		$output['new'] = match (true) {
			$this->new instanceof JobProductsItemChangesBasicTaxStatusNewAlternative1 => $this->new->value, true => $this->new,
		};

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		$this->old = match (true) {
			$this->old instanceof JobProductsItemChangesBasicTaxStatusOldAlternative1, true => $this->old,
		};
		$this->new = match (true) {
			$this->new instanceof JobProductsItemChangesBasicTaxStatusNewAlternative1, true => $this->new,
		};
	}
}
