<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobProductsItemErrorAlternative1 {
	private static array $schema = ['type' => ['object'], 'required' => ['field', 'expected', 'actual'], 'additionalProperties' => false, 'properties' => ['code' => ['type' => 'string', 'enum' => ['value_mismatch'], 'default' => 'value_mismatch'], 'field' => ['type' => 'string'], 'expected' => ['type' => ['string', 'number', 'array', 'null']], 'actual' => ['type' => ['string', 'number', 'array', 'null']]]];
	private JobProductsItemErrorAlternative1Code $code = JobProductsItemErrorAlternative1Code::valuemismatch;
	private string $field;
	private $expected;
	private $actual;

	public function __construct(string $field, $expected, $actual) {
		$this->field = $field;
		$this->expected = $expected;
		$this->actual = $actual;
	}

	public function getCode(): JobProductsItemErrorAlternative1Code {
		return $this->code;
	}

	public function getField(): string {
		return $this->field;
	}

	public function getExpected() {
		return $this->expected;
	}

	public function getActual() {
		return $this->actual;
	}

	public function withCode(JobProductsItemErrorAlternative1Code $code): self {
		$clone = clone $this;
		$clone->code = $code;

		return $clone;
	}

	public function withoutCode(): self {
		$clone = clone $this;
		$clone->code = JobProductsItemErrorAlternative1Code::valuemismatch;

		return $clone;
	}

	public function withField(string $field): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($field, self::$schema['properties']['field']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->field = $field;

		return $clone;
	}

	public function withExpected($expected): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($expected, self::$schema['properties']['expected']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->expected = $expected;

		return $clone;
	}

	public function withActual($actual): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($actual, self::$schema['properties']['actual']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->actual = $actual;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobProductsItemErrorAlternative1 {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $code = JobProductsItemErrorAlternative1Code::valuemismatch;
		if (isset($input->{'code'})) {
			$code = JobProductsItemErrorAlternative1Code::from($input->{'code'});
		} $field = $input->{'field'};
		$expected = $input->{'expected'};
		$actual = $input->{'actual'};
		$obj = new self($field, $expected, $actual);
		$obj->code = $code;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->code)) {
			$output['code'] = $this->code->value;
		} $output['field'] = $this->field;
		$output['expected'] = $this->expected;
		$output['actual'] = $this->actual;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
