<?php

declare(strict_types=1);

namespace ShopManagerPro\Jobs\DTO\Generated;

class JobUserAlternative1 {
	private static array $schema = ['type' => ['object'], 'required' => ['id', 'name'], 'additionalProperties' => false, 'properties' => ['id' => ['type' => 'integer'], 'name' => ['type' => 'string']]];
	private int $id;
	private string $name;

	public function __construct(int $id, string $name) {
		$this->id = $id;
		$this->name = $name;
	}

	public function getId(): int {
		return $this->id;
	}

	public function getName(): string {
		return $this->name;
	}

	public function withId(int $id): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($id, self::$schema['properties']['id']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->id = $id;

		return $clone;
	}

	public function withName(string $name): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($name, self::$schema['properties']['name']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->name = $name;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): JobUserAlternative1 {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $id = (int) $input->{'id'};
		$name = $input->{'name'};
		$obj = new self($id, $name);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['id'] = $this->id;
		$output['name'] = $this->name;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
