<?php

declare(strict_types=1);

namespace ShopManagerPro\Products\DTO\Generated;

class ProductBulkUpdateActionsSpecialProductGroupUpdates {
	private static array $schema = ['type' => 'object', 'additionalProperties' => false, 'properties' => ['add' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]], 'remove' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]]]]];
	private ?array $add = null;
	private ?array $remove = null;

	public function __construct() {
	}

	public function getAdd(): ?array {
		return $this->add ?? null;
	}

	public function getRemove(): ?array {
		return $this->remove ?? null;
	}

	public function withAdd(array $add): self {
		$clone = clone $this;
		$clone->add = $add;

		return $clone;
	}

	public function withoutAdd(): self {
		$clone = clone $this;
		unset($clone->add);

		return $clone;
	}

	public function withRemove(array $remove): self {
		$clone = clone $this;
		$clone->remove = $remove;

		return $clone;
	}

	public function withoutRemove(): self {
		$clone = clone $this;
		unset($clone->remove);

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): ProductBulkUpdateActionsSpecialProductGroupUpdates {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $add = null;
		if (isset($input->{'add'})) {
			$add = array_map(fn (array|object $i): ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem => ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem::buildFromInput($i, validate: $validate), $input->{'add'});
		} $remove = null;
		if (isset($input->{'remove'})) {
			$remove = array_map(fn (array|object $i): ProductBulkUpdateActionsSpecialProductGroupUpdatesRemoveItem => ProductBulkUpdateActionsSpecialProductGroupUpdatesRemoveItem::buildFromInput($i, validate: $validate), $input->{'remove'});
		} $obj = new self();
		$obj->add = $add;
		$obj->remove = $remove;

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		if (isset($this->add)) {
			$output['add'] = array_map(fn (ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem $i) => $i->toJson(), $this->add);
		} if (isset($this->remove)) {
			$output['remove'] = array_map(fn (ProductBulkUpdateActionsSpecialProductGroupUpdatesRemoveItem $i) => $i->toJson(), $this->remove);
		}

return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
		if (isset($this->add)) {
			$this->add = array_map(fn (ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem $i) => clone $i, $this->add);
		} if (isset($this->remove)) {
			$this->remove = array_map(fn (ProductBulkUpdateActionsSpecialProductGroupUpdatesRemoveItem $i) => clone $i, $this->remove);
		}
	}
}
