<?php

declare(strict_types=1);

namespace ShopManagerPro\Products\DTO\Generated;

class ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem {
	private static array $schema = ['type' => 'object', 'required' => ['key', 'values'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'values' => ['type' => 'array']]];
	private string $key;
	private array $values;

	public function __construct(string $key, array $values) {
		$this->key = $key;
		$this->values = $values;
	}

	public function getKey(): string {
		return $this->key;
	}

	public function getValues(): array {
		return $this->values;
	}

	public function withKey(string $key): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($key, self::$schema['properties']['key']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->key = $key;

		return $clone;
	}

	public function withValues(array $values): self {
		$validator = new \JsonSchema\Validator();
		$validator->validate($values, self::$schema['properties']['values']);
		if (!$validator->isValid()) {
			throw new \InvalidArgumentException($validator->getErrors()[0]['message']);
		} $clone = clone $this;
		$clone->values = $values;

		return $clone;
	}

	public static function buildFromInput(array|object $input, bool $validate = true): ProductBulkUpdateActionsSpecialProductGroupUpdatesAddItem {
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		if ($validate) {
			static::validateInput($input);
		} $key = $input->{'key'};
		$values = $input->{'values'};
		$obj = new self($key, $values);

		return $obj;
	}

	public function toJson(): array {
		$output = [];
		$output['key'] = $this->key;
		$output['values'] = $this->values;

		return $output;
	}

	public static function validateInput(array|object $input, bool $return = false): bool {
		$validator = new \JsonSchema\Validator();
		$input = is_array($input) ? \JsonSchema\Validator::arrayToObjectRecursive($input) : $input;
		$validator->validate($input, self::$schema);
		if (!$validator->isValid() && !$return) {
			$errors = array_map(function (array $e): string { return $e['property'].': '.$e['message']; }, $validator->getErrors());
			throw new \InvalidArgumentException(join(', ', $errors));
		}

return $validator->isValid();
	}

	public function __clone() {
	}
}
