<?php

namespace ShopManagerPro\Products\Fields\DTO\ACF;

use ShopManagerPro\Products\Fields\DTO\ProductField;
use ShopManagerPro\Products\Fields\DTO\ProductFieldType;

class ACFField implements ProductField {
	public function __construct(public readonly ?array $choices, public readonly bool $multiple, public readonly int $id, public readonly ProductFieldType $type, public readonly string $fieldKey, public readonly string $label, public readonly string $name, public readonly string $acfType) {
	}

	public function key(): string {
		return ACFFieldGroup::KEY.self::FIELD_TYPE_SEPARATOR.$this->id;
	}
}
