<?php

namespace ShopManagerPro\Products\Fields\DTO\ACF;

use ShopManagerPro\ACF\DTO\ACFFieldType;
use ShopManagerPro\Products\Fields\DTO\ProductFieldGroupType;
use ShopManagerPro\Products\Fields\DTO\ProductFieldType;

class ACFFieldGroup {
	public const KEY = ProductFieldGroupType::ACF->value;

	public function __construct(public readonly array $fieldGroups) {
	}

	public function toProductFieldValues() {
		$result = [];
		foreach ($this->fieldGroups as $groupId => $group) {
			$fields = [];
			foreach ($group->fields as $fieldKey => $field) {
				$fields[$fieldKey] = ['id' => $field->id, 'key' => $field->fieldKey, 'label' => $field->label, 'name' => $field->name, 'multiple' => $field->multiple, 'type' => $field->type->value, 'acfType' => $field->acfType, 'choices' => $field->choices];
			} $result[(string) $groupId] = ['groupId' => $group->groupId, 'groupName' => $group->groupName, 'fields' => $fields];
		}

return $result;
	}

	public function toProductFieldSchema() {
		return ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'required' => ['groupId', 'groupName', 'fields'], 'properties' => ['groupId' => ['type' => 'integer'], 'groupName' => ['type' => 'string'], 'fields' => ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'required' => ['id', 'acfType', 'type', 'key', 'label', 'name', 'multiple'], 'properties' => ['id' => ['type' => 'integer'], 'key' => ['type' => 'string'], 'label' => ['type' => 'string'], 'name' => ['type' => 'string'], 'multiple' => ['type' => 'boolean'], 'type' => ['type' => 'string', 'enum' => array_column(ProductFieldType::cases(), 'value')], 'acfType' => ['type' => 'string', 'enum' => array_column(ACFFieldType::cases(), 'value')], 'choices' => ['type' => ['object', 'null'], 'additionalProperties' => ['type' => 'string']]]]]]]];
	}

	public function toProductSchema() {
		return ['type' => 'object', 'additionalProperties' => ['anyOf' => [['type' => 'string'], ['type' => 'number'], ['type' => 'boolean'], ['type' => 'null'], ['type' => 'array', 'items' => ['type' => 'string']]]]];
	}
}
