<?php

namespace ShopManagerPro\Products\Fields\DTO\Basic;

use ShopManagerPro\Products\Fields\DTO\ProductField;
use ShopManagerPro\Products\Fields\DTO\ProductFieldType;

class BasicField implements ProductField {
	public function __construct(public readonly ProductFieldType $type, public readonly BasicFieldKeys $key, public readonly bool $editable, public readonly bool $nullable, public readonly ?array $options = null) {
	}

	public function key(): string {
		return BasicFieldGroup::KEY.self::FIELD_TYPE_SEPARATOR.$this->key->value;
	}

	public function toProductFieldValues() {
		$result = ['key' => $this->key->value, 'type' => $this->type->value, 'editable' => $this->editable];
		if ($this->options !== null) {
			$result['options'] = $this->options;
		}

return $result;
	}

	public function toProductFieldSchema() {
		return $this->toProductSchema();
	}

	public function toProductSchema() {
		if ($this->key === BasicFieldKeys::GALLERY_IMAGE_IDS) {
			return ['type' => 'array', 'items' => ['type' => 'integer']];
		} $schema = ['type' => $this->type->toOpenAPIType()];
		if ($this->options !== null) {
			$schema['enum'] = $this->options;
		} if ($this->nullable) {
			$schema = ['oneOf' => [$schema, ['type' => 'null']]];
		}

return $schema;
	}
}
