<?php

namespace ShopManagerPro\Products\Fields\DTO\CustomMeta;

use ShopManagerPro\Products\Fields\DTO\ProductFieldGroupType;

class CustomMetaGroup {
	public const KEY = ProductFieldGroupType::META->value;

	public function __construct(public readonly array $fields) {
	}

	public function toProductFieldValues() {
		$result = [];
		foreach ($this->fields as $field) {
			$result[$field->key] = ['key' => $field->key, 'label' => $field->label, 'dataType' => $field->type->value];
		}

return $result;
	}

	public function toProductFieldSchema() {
		return ['type' => 'object', 'additionalProperties' => ['type' => 'object', 'required' => ['key', 'label', 'dataType'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'label' => ['type' => 'string'], 'dataType' => ['type' => 'string', 'enum' => array_column(CustomMetaDataTypes::cases(), 'value')]]]];
	}

	public function toProductSchema() {
		return ['type' => 'object', 'additionalProperties' => ['type' => ['string', 'number', 'integer']]];
	}
}
