<?php

namespace ShopManagerPro\Products\Fields\DTO\ProductAttributes;

use ShopManagerPro\Products\Fields\DTO\ProductFieldGroupType;

class ProductAttributeFieldGroup {
	public const KEY = ProductFieldGroupType::PRODUCT_ATTRIBUTE->value;

	public function __construct(public readonly array $fields) {
	}

	public function toArray() {
		return $this->fields;
	}

	public function toProductFieldSchema() {
		return ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['key', 'name', 'terms'], 'additionalProperties' => false, 'properties' => ['key' => ['type' => 'string'], 'name' => ['type' => 'string'], 'terms' => ['type' => 'array', 'items' => ['type' => 'object', 'required' => ['id', 'name'], 'additionalProperties' => false, 'properties' => ['id' => ['type' => 'integer'], 'name' => ['type' => 'string']]]]]]];
	}

	public function toProductFieldValues() {
		$result = [];
		foreach ($this->fields as $field) {
			$terms = [];
			foreach ($field->terms as $term) {
				$terms[] = ['id' => $term->id, 'name' => $term->name];
			} $result[] = ['key' => $field->key, 'name' => $field->name, 'terms' => $terms];
		}

return $result;
	}

	public function toProductSchema() {
		return ['type' => 'object', 'additionalProperties' => ['type' => 'array', 'items' => ['type' => 'integer']]];
	}
}
