<?php

namespace ShopManagerPro\Shared;

class InitService {
	public static function init() {
		if (!SHOP_MANAGER_PRO_COMMERCIAL && is_plugin_active('shopmanagerpro-premium/shopmanagerpro.php')) {
			return;
		} require_once SHOP_MANAGER_PRO_PLUGIN_DIR.'vendor/autoload.php';
		DatabaseManagerService::runMigrations();
		PluginDetectorService::detect();
		\ShopManagerPro\System\SystemInfoAPI::init();
		\ShopManagerPro\Filters\FilterAPI::init();
		\ShopManagerPro\Images\ImageAPI::init();
		\ShopManagerPro\Products\Fields\ProductFieldAPI::init();
		\ShopManagerPro\Products\ProductAPI::init();
		\ShopManagerPro\TaxClasses\TaxClassAPI::init();
		\ShopManagerPro\Taxonomies\TaxonomyAPI::init();
		\ShopManagerPro\Jobs\JobProcessorService::init();
		MenuPageService::init();
		UpdateCheckerService::init();
		\ShopManagerPro\Jobs\JobAPI::init();
		self::initLanguages();
		if (SHOP_MANAGER_PRO_COMMERCIAL || (defined('SHOP_MANAGER_PRO_FREE') && !constant('SHOP_MANAGER_PRO_FREE'))) {
			\ShopManagerPro\Premium\InitService::init();
		} add_action('admin_enqueue_scripts', [self::class, 'enqueue_scripts'], 1);
	}

	public static function enqueue_scripts(string $hook) {
		if (false === strpos($hook, 'shopmanagerpro')) {
			return;
		} wp_enqueue_script('shopmanagerpro-admin-script', SHOP_MANAGER_PRO_PLUGIN_URL.'assets/shopmanagerpro.iife.js', [], SHOP_MANAGER_PRO_VERSION, true);
		wp_enqueue_style('shopmanagerpro-admin-style', SHOP_MANAGER_PRO_PLUGIN_URL.'assets/shopmanagerpro.css', [], SHOP_MANAGER_PRO_VERSION);
		wp_localize_script('shopmanagerpro-admin-script', 'shopManagerProData', \ShopManagerPro\System\SystemInfoAPI::getData());
	}

	private static function initLanguages() {
		global $wp_textdomain_registry;
		$wp_textdomain_registry->set_custom_path('shopmanagerpro', SHOP_MANAGER_PRO_PLUGIN_DIR.'languages');
	}
}
