<?php

namespace ShopManagerPro\Shared\Utils;

class SQL {
	public static function stringPlaceholders(int $count) {
		return self::sqlPlaceholders($count, 's');
	}

	public static function intPlaceholders(int $count) {
		return self::sqlPlaceholders($count, 'd');
	}

	public static function sqlPlaceholders(int $count, string $type) {
		if ($count < 1) {
			throw new \InvalidArgumentException('Count must be greater than 0');
		} if ($type !== 's' && $type !== 'd' && $type !== 'i' && $type !== 'f') {
			throw new \InvalidArgumentException('Type must be one of "s", "d", "i", or "f"');
		} $placeholders = array_fill(0, $count, '%'.$type);

		return implode(' , ', $placeholders);
	}
}
