<?php

namespace ShopManagerPro\Taxonomies;

class TaxonomyNameService {
	private static array $wooCommerceTaxonomyNames = [];
	private static array $hardcodedTaxonomyNames = [];

	public static function getTaxonomyName(string $taxonomyKey) {
		$wooCommerceTaxonomyNames = self::getWooCommerceTaxonomyNames();
		if (isset($wooCommerceTaxonomyNames[$taxonomyKey])) {
			return $wooCommerceTaxonomyNames[$taxonomyKey];
		} $hardcodedTaxonomyNames = self::getHardcodedTaxonomyNames();
		if (isset($hardcodedTaxonomyNames[$taxonomyKey])) {
			return $hardcodedTaxonomyNames[$taxonomyKey];
		}

return $taxonomyKey;
	}

	private static function getWooCommerceTaxonomyNames() {
		if (self::$wooCommerceTaxonomyNames) {
			return self::$wooCommerceTaxonomyNames;
		} $wooCommerceTaxonomyNames = [];
		foreach (wc_get_attribute_taxonomies() as $taxonomy) {
			$wooCommerceTaxonomyNames['pa_'.$taxonomy->attribute_name] = $taxonomy->attribute_label;
		} self::$wooCommerceTaxonomyNames = $wooCommerceTaxonomyNames;

		return $wooCommerceTaxonomyNames;
	}

	private static function getHardcodedTaxonomyNames() {
		switch_to_locale(get_user_locale());
		if (!self::$hardcodedTaxonomyNames) {
			self::$hardcodedTaxonomyNames = ['product_brand' => __('Brand', 'shopmanagerpro'), 'product_cat' => __('Category', 'shopmanagerpro'), 'product_shipping_class' => __('Shipping class', 'shopmanagerpro'), 'product_tag' => __('Tag', 'shopmanagerpro'), 'product_type' => __('Type', 'shopmanagerpro'), 'product_visibility' => __('Visibility', 'shopmanagerpro')];
		}

return self::$hardcodedTaxonomyNames;
	}
}
